<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/config/config.php';

echo "<h1>🔍 Debug IPPanel API</h1>";
echo "<style>body{font-family:Tahoma;padding:20px;direction:rtl;} .success{color:green;} .error{color:red;} .warning{color:orange;} pre{background:#f5f5f5;padding:15px;border-radius:8px;direction:ltr;overflow-x:auto;}</style>";

// Get settings
$apiKey = getSetting('ippanel_api_key', '');
$patternCode = getSetting('ippanel_pattern_code', '');
$sender = getSetting('ippanel_sender', '');
$testMode = getSetting('otp_test_mode', '0');

echo "<h2>1️⃣ تنظیمات فعلی</h2>";
echo "<p class='success'>✅ API Key: " . substr($apiKey, 0, 30) . "...</p>";
echo "<p class='success'>✅ Pattern Code: $patternCode</p>";
echo "<p class='success'>✅ Sender: $sender</p>";
echo "<p class='" . ($testMode === '1' ? 'warning' : 'success') . "'>" . ($testMode === '1' ? '⚠️ Test Mode: فعال' : '✅ Test Mode: غیرفعال') . "</p>";

// Test phone number
$testPhone = '09123456789';
$testOtp = '1234';

echo "<h2>2️⃣ تست ارسال SMS</h2>";
echo "<p>شماره تست: <strong>$testPhone</strong></p>";
echo "<p>کد OTP تست: <strong>$testOtp</strong></p>";

if ($testMode === '1') {
    echo "<p class='warning'>⚠️ حالت تست فعال است - SMS واقعی ارسال نمی‌شود</p>";
    echo "<p><a href='/otp-settings.php'>رفتن به تنظیمات</a> برای غیرفعال کردن حالت تست</p>";
}

// Prepare request
$url = 'https://api2.ippanel.com/api/v1/sms/pattern/normal/send';

$data = [
    'code' => $patternCode,
    'sender' => $sender,
    'recipient' => $testPhone,
    'variable' => [
        'OTP' => $testOtp
    ]
];

echo "<h3>📤 Request Details:</h3>";
echo "<pre>";
echo "URL: $url\n\n";
echo "Headers:\n";
echo "  apikey: " . substr($apiKey, 0, 30) . "...\n";
echo "  Content-Type: application/json\n\n";
echo "Body:\n";
echo json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
echo "</pre>";

// Send request
if (isset($_GET['send'])) {
    echo "<h3>📥 Response:</h3>";
    
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'apikey: ' . $apiKey,
        'Content-Type: application/json'
    ]);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_VERBOSE, true);
    
    $verbose = fopen('php://temp', 'w+');
    curl_setopt($ch, CURLOPT_STDERR, $verbose);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curlError = curl_error($ch);
    $curlInfo = curl_getinfo($ch);
    
    rewind($verbose);
    $verboseLog = stream_get_contents($verbose);
    
    curl_close($ch);
    
    echo "<pre>";
    echo "HTTP Status Code: $httpCode\n\n";
    
    if ($curlError) {
        echo "❌ cURL Error: $curlError\n\n";
    }
    
    echo "Response Body:\n";
    echo $response . "\n\n";
    
    // Try to decode JSON
    $responseData = json_decode($response, true);
    if ($responseData) {
        echo "Decoded Response:\n";
        echo json_encode($responseData, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "\n\n";
    }
    
    echo "cURL Info:\n";
    echo "  Total Time: " . $curlInfo['total_time'] . " seconds\n";
    echo "  Connect Time: " . $curlInfo['connect_time'] . " seconds\n";
    echo "  Size Download: " . $curlInfo['size_download'] . " bytes\n";
    echo "</pre>";
    
    // Analyze result
    echo "<h3>📊 تحلیل نتیجه:</h3>";
    
    if ($httpCode === 200 || $httpCode === 201) {
        echo "<p class='success'>✅ موفق! SMS ارسال شد</p>";
    } elseif ($httpCode === 403) {
        echo "<p class='error'>❌ خطای 403: دسترسی رد شد</p>";
        echo "<p>احتمالات:</p>";
        echo "<ul>";
        echo "<li>API Key اشتباه است</li>";
        echo "<li>IP سرور در پنل IPPanel مجاز نیست</li>";
        echo "<li>Pattern Code اشتباه است</li>";
        echo "<li>حساب IPPanel غیرفعال یا منقضی شده</li>";
        echo "</ul>";
        echo "<p><strong>راه‌حل:</strong></p>";
        echo "<ol>";
        echo "<li>به پنل IPPanel بروید</li>";
        echo "<li>API Key را چک کنید</li>";
        echo "<li>IP سرور را در whitelist اضافه کنید</li>";
        echo "<li>Pattern Code را بررسی کنید</li>";
        echo "<li>موجودی حساب را چک کنید</li>";
        echo "</ol>";
    } elseif ($httpCode === 401) {
        echo "<p class='error'>❌ خطای 401: احراز هویت ناموفق</p>";
        echo "<p>API Key نامعتبر است. لطفاً API Key را در تنظیمات بررسی کنید.</p>";
    } elseif ($httpCode === 400) {
        echo "<p class='error'>❌ خطای 400: درخواست نامعتبر</p>";
        echo "<p>پارامترهای ارسالی اشتباه هستند. Pattern Code یا Sender را بررسی کنید.</p>";
    } else {
        echo "<p class='error'>❌ خطای HTTP $httpCode</p>";
    }
    
    echo "<p><a href='?'>بازگشت</a></p>";
} else {
    echo "<p style='margin-top:20px;'>";
    echo "<a href='?send=1' style='background:#667eea;color:white;padding:12px 24px;border-radius:8px;text-decoration:none;display:inline-block;font-weight:bold;'>";
    echo "🚀 ارسال تست SMS";
    echo "</a>";
    echo "</p>";
    
    echo "<p style='color:#666;margin-top:15px;'>";
    echo "⚠️ توجه: این درخواست واقعی است و SMS ارسال می‌شود (اگر حالت تست غیرفعال باشد)";
    echo "</p>";
}

echo "<hr style='margin:40px 0;'>";
echo "<h2>3️⃣ راهنمای رفع خطای 403</h2>";
echo "<div style='background:#fff3cd;padding:20px;border-radius:10px;border-right:4px solid #ffc107;'>";
echo "<h3>🔧 مراحل رفع مشکل:</h3>";
echo "<ol style='line-height:2;'>";
echo "<li><strong>بررسی API Key:</strong> به پنل IPPanel بروید و API Key را کپی کنید</li>";
echo "<li><strong>بررسی Pattern:</strong> مطمئن شوید Pattern Code درست است (مثال: v43ncjmlxcwaczv)</li>";
echo "<li><strong>بررسی IP:</strong> IP سرور خود را در whitelist پنل IPPanel اضافه کنید</li>";
echo "<li><strong>بررسی موجودی:</strong> موجودی حساب IPPanel را چک کنید</li>";
echo "<li><strong>بررسی Sender:</strong> شماره ارسال‌کننده باید در پنل تایید شده باشد</li>";
echo "</ol>";

echo "<h3 style='margin-top:20px;'>📝 IP سرور شما:</h3>";
echo "<p style='font-size:1.2em;font-weight:bold;color:#667eea;'>";
echo $_SERVER['SERVER_ADDR'] ?? 'نامشخص';
echo "</p>";
echo "<p>این IP را در پنل IPPanel در بخش API Settings به whitelist اضافه کنید.</p>";
echo "</div>";

echo "<hr style='margin:40px 0;'>";
echo "<p><a href='/otp-settings.php' style='background:#10b981;color:white;padding:12px 24px;border-radius:8px;text-decoration:none;display:inline-block;font-weight:bold;'>";
echo "⚙️ رفتن به تنظیمات OTP";
echo "</a></p>";
?>

